-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.p0 = Citadels.GetPlayer(0)
    self.active = true
    self.timeLimit = 4
    
    if not self.loaded then
      self.timer = self.timeLimit
    end
    
    self.resourceCond:LinkToTarget("victory")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
    
    if self.timer <= 0 then
      CheckVictoryCond(self)
      self.timer = self.timeLimit
    end
  end 
end

function CheckVictoryCond(self)
  if self.p0:GetResource(2) >= 600 
    and self.p0:GetResource(3) >= 650
      and self.p0:GetResource(4) >= 140
        and self.p0:GetResource(7) >= 140 then
          self.resourceCond:TriggerAllTargets()
          self.active = false
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.timer)
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("resourceCond")
end
